<?php $__env->startSection('isi'); ?>
   <div class="container-fluid">
       <?php
            date_default_timezone_set('Asia/Jakarta');
        ?>

        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <?php echo e($title); ?>

            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped" id="tableprint" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Nama Karyawan</th>
                                <th>Total Hadir</th>
                                <th>Total Alfa</th>
                                <th>Total Libur</th>
                                <th>Total Telat</th>
                                <th>Total Pulang Cepat</th>
                                <th>Total Lembur</th>
                                <th>Total Cuti Dadakan</th>
                                <th>Total Cuti Bersama</th>
                                <th>Total Cuti Menikah</th>
                                <th>Total Cuti Diluar Tanggungan</th>
                                <th>Total Cuti Khusus</th>
                                <th>Total Cuti Melahirkan</th>
                                <th>Total Izin Telat</th>
                                <th>Total Izin Pulang Cepat</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <?php $__currentLoopData = $nama_user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($nu->name); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td><?php echo e($jumlah_hadir + $jumlah_izin_telat + $jumlah_izin_pulang_cepat); ?> x</td>
                                <td><?php echo e($jumlah_tidak_masuk); ?> x</td>
                                <td><?php echo e($jumlah_libur); ?> x</td>
                                <td>
                                    <?php
                                        $jam   = floor($total_telat / (60 * 60));
                                        $menit = $total_telat - ( $jam * (60 * 60) );
                                        $menit2 = floor($menit / 60);
                                        $detik = $total_telat % 60;
                                    ?>
                                    <?php if($jam <= 0 && $menit2 <= 0): ?>
                                        <span class="badge badge-success">Tidak Pernah Telat</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger"><?php echo e($jam." Jam ".$menit2." Menit"); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php
                                        $jam   = floor($total_pulang_cepat / (60 * 60));
                                        $menit = $total_pulang_cepat - ( $jam * (60 * 60) );
                                        $menit2 = floor($menit / 60);
                                        $detik = $total_pulang_cepat % 60;
                                    ?>
                                    <?php if($jam <= 0 && $menit2 <= 0): ?>
                                        <span class="badge badge-success">Tidak Pernah Pulang Cepat</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger"><?php echo e($jam." Jam ".$menit2." Menit"); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php
                                        $jam   = floor($total_lembur / (60 * 60));
                                        $menit = $total_lembur - ( $jam * (60 * 60) );
                                        $menit2 = floor($menit / 60);
                                        $detik = $total_lembur % 60;
                                    ?>
                                        <span class="badge badge-success"><?php echo e($jam." Jam ".$menit2." Menit"); ?></span>
                                </td>
                                <td><?php echo e($jumlah_cuti_dadakan); ?> x</td>
                                <td><?php echo e($jumlah_cuti_bersama); ?> x</td>
                                <td><?php echo e($jumlah_cuti_menikah); ?> x</td>
                                <td><?php echo e($jumlah_cuti_diluar_tanggungan); ?> x</td>
                                <td><?php echo e($jumlah_cuti_khusus); ?> x</td>
                                <td><?php echo e($jumlah_cuti_melahirkan); ?> x</td>
                                <td><?php echo e($jumlah_izin_telat); ?> x</td>
                                <td><?php echo e($jumlah_izin_pulang_cepat); ?> x</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
   </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\absensi\resources\views/rekapdata/result.blade.php ENDPATH**/ ?>