<?php $__env->startSection('isi'); ?>
    <?php
        $lat_kantor = $lokasi_kantor->lat_kantor;
        $long_kantor = $lokasi_kantor->long_kantor;
        $radius = $lokasi_kantor->radius;
    ?>
    <div class="container-fluid">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
               <h1 class="h3 mb-2 text-gray-800"><?php echo e($lat); ?>, <?php echo e($long); ?></h1>
           </div>
            <div class="card-body">
               <div id="map" style="width:100%;height:600px;"></div>
               <script>
                   var map = L.map('map').setView([<?php echo e($lat); ?>, <?php echo e($long); ?>], 18);
                   L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                   maxZoom: 19,
                   attribution: '© OpenStreetMap'
                   }).addTo(map);
                   var marker = L.marker([<?php echo e($lat); ?>, <?php echo e($long); ?>]).addTo(map);
                   var circle = L.circle([<?php echo e($lat_kantor); ?>, <?php echo e($long_kantor); ?>], {
                   color: 'red',
                   fillColor: '#f03',
                   fillOpacity: 0.5,
                   radius: <?php echo e($radius); ?>

                   }).addTo(map);

                   marker.bindPopup("<b>Lokasi Saya</b>").openPopup();
                   circle.bindPopup("<b>Radius RSGPI</b>");
               </script>

            </div>
        </div>
        <br><br>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\16_Laravel_Absensi\absensi\resources\views/absen/maps.blade.php ENDPATH**/ ?>