<?php $__env->startSection('isi'); ?>
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <center>
                <a class="btn btn-primary" href="<?php echo e(url('/data-cuti/tambah')); ?>">+ Tambah Cuti Karyawan</a>
            </center>
        </div>
        <div class="card-body p-3">
                <table class="table table-striped" id="tableprint" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th>Nama Karyawan</th>
                            <th>Nama Cuti</th>
                            <th>Tanggal</th>
                            <th>Alasan Cuti</th>
                            <th>Foto Cuti</th>
                            <th>Status Cuti</th>
                            <th>Catatan</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $data_cuti; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($dc->User->name); ?></td>
                            <td><?php echo e($dc->nama_cuti); ?></td>
                            <td><?php echo e($dc->tanggal); ?></td>
                            <td><?php echo e($dc->alasan_cuti); ?></td>
                            <td>
                                <img src="<?php echo e(url('storage/'.$dc->foto_cuti)); ?>" style="width: 200px" alt="">
                            </td>
                            <td>
                                <?php if($dc->status_cuti == "Diterima"): ?>
                                    <span class="badge badge-success"><?php echo e($dc->status_cuti); ?></span>
                                <?php elseif($dc->status_cuti == "Ditolak"): ?>
                                    <span class="badge badge-danger"><?php echo e($dc->status_cuti); ?></span>
                                <?php else: ?>
                                    <span class="badge badge-warning"><?php echo e($dc->status_cuti); ?></span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($dc->catatan); ?></td>
                            <td>
                                <?php if($dc->status_cuti == "Diterima"): ?>
                                    <span class="badge badge-success">Sudah Approve</span>
                                <?php else: ?>
                                    <a href="<?php echo e(url('/data-cuti/edit/'.$dc->id)); ?>" class="btn btn-warning btn-sm"><i class="fas fa-exclamation-triangle"></i></a>
                                <?php endif; ?>

                                <?php if($dc->status_cuti == "Diterima"): ?>
                                    <span class="badge badge-success">Sudah Approve</span>
                                <?php else: ?>
                                    <form action="<?php echo e(url('/data-cuti/delete/'.$dc->id)); ?>" method="post" class="d-inline">
                                        <?php echo method_field('delete'); ?>
                                        <?php echo csrf_field(); ?>
                                        <button class="btn btn-danger btn-sm" onClick="return confirm('Are You Sure')"><i class="fas fa-trash"></i></button>
                                    </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
        </div>
    </div>
    <br>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\absensi\resources\views/cuti/datacuti.blade.php ENDPATH**/ ?>